/*------------------------------------------------------------------------------*
 * File Name: ImpWizDataSelection.h												*
 * Creation: Jacky 12/14/2003													*
 * Purpose: Origin C file containing Application Utilities						*
 * Copyright (c) OriginLab Corp.	2002-2007									*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *	 Jacky 12/14/03 v7.5781 NOT_NEED_DIALOG_TO_CALL	                            *
 *   Jacky 12/14/03 v7.5781 CHANGE_FUNCTION_NAME                                *
 *   Jacky 12/14/03 v7.5781 PAGE_QUESTION_UNDO     								*
 *   Jacky 12/14/03 v7.5781 DEFINE_SOME_NEW_MEMBER 								*
 *   Jacky 12/21/03 v7.5784 CALL_SHEET_FUNCTION									*
 *   Danice 12/23/03 v7.5786 SAVE_CHANGE										*
 *   Danice 12/26/03 v7.5789 UPDATE_DIRECTLY									*
 * EJP 01-15-2004 v7.5802 QA70-5211 CHECK_BINIMP_PARTIAL_COL_RANGE				*
 *   Danice 1/16/04 v8.0800 NEW_ACCESS_METHOD_GET_POINTER						*
 *   Danice 2/24/04 v8.0825 PREVENT_INIT_RUN_IN_ASC_AND_BIN						*
 * EJP 02-26-2004 v7.5828 ONLY_CREATE_WKS_CTRL_ONCE								*
 * Danice 3/1/04 v8.0828 PAGE_INIT_ONCE											*
 * EJP 01-04-2005 v8.0181 QA70-6555 NEW_IMPORT_MODES							*
 *------------------------------------------------------------------------------*/
 
////////////////////////////////////////////////////////////////////////////////////
// Included header files
//////////////////////////////////////////////////////////////////////////////////
//

#define ON_PAGE_CHECK_PARTIAL_IMPORT		if(!IS_SHOW_PARTIAL_IMPORT_PAGE) return FALSE;

enum {
	NONNUMERIC_WIZ_TERMINATE = 0,
	NONNUMERIC_WIZ_READ_AS_TEXT,
	NONNUMERIC_WIZ_NEW_WKS,
	NONNUMERIC_WIZ_NEW_COL
};

class ImpWizDataSelectionPage : public ImpWizardPage
{
	
	// Constructor for ImpWizHeaderBytesPage class, use parent constructor
	//ImpWizDataSelectionPage(int nID) : ImpWizardPage(nID) {}
public:
	
	EVENTS_BEGIN
		///Jacky 12/14/03 v7.5781 CHANGE_FUNCTION_NAME		
		//PAGE_ON_IS_SHOW(OnIsShow_Range)		///Danice 12/25/03 v7.5788 NOTUSE_SHOW
		PAGE_ON_INIT(OnInit_Range)
		PAGE_ON_ACTIVE(OnActive_Range)
		PAGE_ON_KILLACTIVE(OnKillActive_Range)
		
		ON_CBN_SELCHANGE(IDC_RANGE_MODE, OnSelChangeMode_Range)
		ON_BN_CLICKED(IDC_RANGE_PARTIAL, OnClickPartial_Range)
		///End CHANGE_FUNCTION_NAME
		
		/// EJP 07-21-2003 v7.0630 QA70-4073 ADD_APPLY_BUTTON_TO_UPDATE_PREVIEW
		/*
		ON_EN_CHANGE(IDC_RANGE_FIRSTCOL, Range_OnEditChangeFirstCol)
		ON_EN_CHANGE(IDC_RANGE_LASTCOL, Range_OnEditChangeLastCol)
		ON_EN_CHANGE(IDC_RANGE_FIRSTROW, Range_OnEditChangeFirstRow)
		ON_EN_CHANGE(IDC_RANGE_LASTROW, Range_OnEditChangeLastRow)
		*/
		ON_BN_CLICKED(IDC_APPLY_PARTIAL, OnClickApplyPartial_Range) ///Jacky 12/14/03 v7.5781 CHANGE_FUNCTION_NAME		
		/// end ADD_APPLY_BUTTON_TO_UPDATE_PREVIEW

		ON_EN_CHANGE(IDC_IW_SKIP_ROWS, OnEditChangeSkipDataRows)
		/// EJP 08-27-2003 v7.5677 QA70-5073 ADD_READROWS
		ON_EN_CHANGE(IDC_IW_READ_ROWS, OnEditChangeReadRows)
		/// end ADD_READROWS
		
		/// Hong 08/05/10 ORG-721 IMPWIZ_SETTING_WITH_APPLY_BTN_SHOULD_AUTO_APPLY_WHEN_NEXT
		ON_EN_CHANGE(IDC_RANGE_FIRSTCOL, OnEditChangePartial)
		ON_EN_CHANGE(IDC_RANGE_FIRSTROW, OnEditChangePartial)
		ON_EN_CHANGE(IDC_RANGE_LASTROW, OnEditChangePartial)
		ON_EN_CHANGE(IDC_RANGE_LASTCOL, OnEditChangePartial)
		/// end IMPWIZ_SETTING_WITH_APPLY_BTN_SHOULD_AUTO_APPLY_WHEN_NEXT

		ON_CBN_SELCHANGE(IDC_IW_HEADER_NONNUMERIC, OnSelChangeNonNumeric)

	EVENTS_END
	
protected :
	//Events handles
		
	///Danice 12/25/03 v7.5788 NOTUSE_SHOW
	/*
	//--------------------------------------------------------------------------
	// OnIsShowUserDefined
	//
	// ON_PAGE_IS_SHOW handler function for all User Defined pages.
	//--------------------------------------------------------------------------
	BOOL OnIsShow_Range(DWORD dwPageID, DWORD lParam);///Jacky 12/14/03 v7.5781 CHANGE_FUNCTION_NAME
	*/
	DWORD    OnShowStatus(DWORD InternalStatus);
	///END NOTUSE_SHOW
	
	//--------------------------------------------------------------------------
	// UpdateWksCtrl
	//
	// Call this function to update the worksheet control on the specified page.
	//--------------------------------------------------------------------------
	void UpdateWksCtrl(int iWizPageID);

	void UpdatePreview(int iWizPageID);
	
	BOOL OnInit_Range(); ///Jacky 12/14/03 v7.5781 CHANGE_FUNCTION_NAME
	
	BOOL OnActive_Range(); ///Jacky 12/14/03 v7.5781 CHANGE_FUNCTION_NAME
	
	bool OnKillActive_Range();
	
	BOOL OnSelChangeNonNumeric(Control ctrl);
	
	BOOL OnSelChangeMode_Range(Control ctrl); ///Jacky 12/14/03 v7.5781 CHANGE_FUNCTION_NAME
	
	BOOL OnClickPartial_Range(Control ctrl);///Jacky 12/14/03 v7.5781 CHANGE_FUNCTION_NAME
	
	/// EJP 07-21-2003 v7.0630 QA70-4073 ADD_APPLY_BUTTON_TO_UPDATE_PREVIEW
	/*
	BOOL Range_OnEditChangeFirstCol(Control ctrl);
	BOOL Range_OnEditChangeLastCol(Control ctrl);
	BOOL Range_OnEditChangeFirstRow(Control ctrl);
	BOOL Range_OnEditChangeLastRow(Control ctrl);
	*/
	BOOL OnClickApplyPartial_Range(Control ctrl);///Jacky 12/14/03 v7.5781 CHANGE_FUNCTION_NAME
	/// end ADD_APPLY_BUTTON_TO_UPDATE_PREVIEW
	
	BOOL OnEditChangeSkipDataRows(Control ctrl);
	
	/// EJP 08-27-2003 v7.5677 QA70-5073 ADD_READROWS
	BOOL OnEditChangeReadRows(Control ctrl);
	/// end ADD_READROWS
	
	/// Hong 08/05/10 ORG-721 IMPWIZ_SETTING_WITH_APPLY_BTN_SHOULD_AUTO_APPLY_WHEN_NEXT
	BOOL OnEditChangePartial(Control ctrl);
	/// end /// Hong 08/05/10 ORG-721 IMPWIZ_SETTING_WITH_APPLY_BTN_SHOULD_AUTO_APPLY_WHEN_NEXT
	
	void	Range_EnablePartialCtrls(BOOL bEnable=true);
	
	void DataSel_UpdateNonNumericCtrls();

	/// EJP 01-04-2005 v8.0181 QA70-6555 NEW_IMPORT_MODES
	///void DataSel_ConvertStructToDialog(int &iNonNumeric, int &iImportMode);
	///void DataSel_ConvertDialogToStruct(int &iNonNumeric, int &iImportMode);
	/// end NEW_IMPORT_MODES

	void Range_UpdateData(BOOL bDlgToData=true);
	
private:
	
	///Jacky 12/14/03 v7.5781 DEFINE_SOME_NEW_MEMBER 
	
	Edit m_editFirstCol;
	Edit m_editFirstRow;
	Edit m_ebSkipDataRows;
	Edit m_ebReadRows;
	Edit m_editLastRow;
	Edit m_editLastCol;
	Button   m_chkPartial;
	Button   m_btnApply;
	Control  m_ctrlNonNumericLabel;
	ComboBox m_cbImportMode;
	ComboBox m_cbNonNumeric;
	WorksheetControl m_wc;
	
	///Danice 1/16/04 v8.0800 NEW_ACCESS_METHOD_GET_POINTER
	//ASCIMP 		m_pAscimp;
	//BINIMP 		m_pBinimp ;
	ASCIMP* 		m_pAscimp;
	BINIMP* 		m_pBinimp ;
	///END NEW_ACCESS_METHOD_GET_POINTER
	///End DEFINE_SOME_NEW_MEMBER

	bool			bHasInit;	///Danice 2/24/04 v8.0825 PREVENT_INIT_RUN_IN_ASC_AND_BIN
	bool			m_bPartialChanged; /// Hong 08/05/10 ORG-721 IMPWIZ_SETTING_WITH_APPLY_BTN_SHOULD_AUTO_APPLY_WHEN_NEXT
};